//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import "Config.h"
@implementation Config: NSObject

#pragma mark - sharedInstance
+ (Config *) sharedInstance{
    static Config *sharedInstance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{ sharedInstance = [[Config alloc] init]; });
    return sharedInstance;
}

#pragma mark - getUseCaseConfig
- (void) getUseCaseConfig:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    ISO15693Command *readTagConfigRegCommand = [[ISO15693Command alloc] initWithData:cmd_readTagConfigReg];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: readTagConfigRegCommand onSuccess:^(NSData *aData) {
        NSString *response = [[Config sharedInstance] parseUseCaseConfig:aData];
        [[NTAG5_NFC_LIB sharedInstance] setMessage:response];
        [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {} onFailure:^(NSError *error) {}];
    } onFailure:^(NSError *error) {
         NSLog(@"getUseCaseConfig error :\n%@", error.localizedDescription);
    }];
}

#pragma mark - parseUseCaseConfig
- (NSString *) parseUseCaseConfig:(NSData *)resp {
    NSString *stringResp;
    const char *byte = [resp bytes];
    
    if(byte == NULL)
        return nil;
    if( (byte[1] & 0x30) == 0x00){
        stringResp = str_i2c_slave_config;
    }
    else if( (byte[1] & 0x30) == 0x10){
        stringResp = str_i2c_master_config;
    }
    else if( (byte[1] & 0x30) == 0x20){
        stringResp = str_gpip_pwm_config;
    }else{
        stringResp = str_unknown_config;
    }
    
    return stringResp;
}

#pragma mark - setI2CSlave
- (void) setI2CSlave:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    ISO15693Command *activateI2CSlaveCommand = [[ISO15693Command alloc] initWithData:cmd_activateI2CSlave];
    ISO15693Command *readI2cAddrCommand = [[ISO15693Command alloc] initWithData: cmd_readI2cAddr];
    
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: activateI2CSlaveCommand onSuccess:^(NSData *aData) {
        [[NTAG5_NFC_LIB sharedInstance] sendCommand: readI2cAddrCommand onSuccess:^(NSData *aData) {
                  if (aData.length != 0){
                      char * i2cAddr = [[aData subdataWithRange:NSMakeRange(0, 1)] bytes];
                      if ( i2cAddr[0] == 0x54){
                          NSLog(@"getUseCaseConfig Success :\n%@", aData);
                          [[NTAG5_NFC_LIB sharedInstance] setMessage:str_success];
                      } else{
                          NSString * finalMessage = [NSString stringWithFormat:@"%@0x%02x%@", str_i2cAddr1, i2cAddr[0], str_i2cAddr2];
                          [[NTAG5_NFC_LIB sharedInstance] setMessage:finalMessage];
                      }
                  }
                  [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {} onFailure:^(NSError *error) {
                      NSLog(@"setI2CSlave error :\n%@", error.localizedDescription);
                  }];
              } onFailure:^(NSError *error) {
                  NSLog(@"setI2CSlave error :\n%@", error.localizedDescription);
              }];
    } onFailure:^(NSError *error) {
        NSLog(@"setI2CSlave error :\n%@", error.localizedDescription);
    }];
}

#pragma mark - setI2CMaster
- (void) setI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    ISO15693Command *activateI2CMasterCommand = [[ISO15693Command alloc] initWithData: cmd_activateI2CMaster];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: activateI2CMasterCommand onSuccess:^(NSData *aData) {
        [[NTAG5_NFC_LIB sharedInstance] setMessage:str_success];
        [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {} onFailure:^(NSError *error) {
             NSLog(@"setI2CMaster error :\n%@", error.localizedDescription);
        }];
    } onFailure:^(NSError *error) {
         NSLog(@"setI2CMaster error :\n%@", error.localizedDescription);
    }];
}

#pragma mark - setI2CMaster
- (void) setGPIOPWM:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure{
    ISO15693Command *activateGPIOPWMCommand = [[ISO15693Command alloc] initWithData:cmd_activateGPIOPWM];
    [[NTAG5_NFC_LIB sharedInstance] sendCommand: activateGPIOPWMCommand onSuccess:^(NSData *aData) {
        NSLog(@"getUseCaseConfig Success :\n%@", aData);
        [[NTAG5_NFC_LIB sharedInstance] setMessage:str_success];
        [[NTAG5_NFC_LIB sharedInstance] close:^(NSData *aData) {} onFailure:^(NSError *error) {
            NSLog(@"setGPIOPWM error :\n%@", error.localizedDescription);
        }];
    } onFailure:^(NSError *error) {
         NSLog(@"setGPIOPWM error :\n%@", error.localizedDescription);
    }];
}
@end
